import { attach, detach, singleton } from "./helpers.mjs";
class CaptureStackFrame {
  constructor(below, child) {
    this.below = below;
    this.child = child;
  }
  offset = 0;
  maybeRemoved;
}
const inst = singleton("capture", () => ({ stack: null }));
function unsafe__withoutCapture(fn) {
  const oldStack = inst.stack;
  inst.stack = null;
  try {
    return fn();
  } finally {
    inst.stack = oldStack;
  }
}
function startCapturingParents(child) {
  inst.stack = new CaptureStackFrame(inst.stack, child);
  child.parentSet.clear();
}
function stopCapturingParents() {
  const frame = inst.stack;
  inst.stack = frame.below;
  if (frame.offset < frame.child.parents.length) {
    for (let i = frame.offset; i < frame.child.parents.length; i++) {
      const maybeRemovedParent = frame.child.parents[i];
      if (!frame.child.parentSet.has(maybeRemovedParent)) {
        detach(maybeRemovedParent, frame.child);
      }
    }
    frame.child.parents.length = frame.offset;
    frame.child.parentEpochs.length = frame.offset;
  }
  if (frame.maybeRemoved) {
    for (let i = 0; i < frame.maybeRemoved.length; i++) {
      const maybeRemovedParent = frame.maybeRemoved[i];
      if (!frame.child.parentSet.has(maybeRemovedParent)) {
        detach(maybeRemovedParent, frame.child);
      }
    }
  }
}
function maybeCaptureParent(p) {
  if (inst.stack) {
    const wasCapturedAlready = inst.stack.child.parentSet.has(p);
    if (wasCapturedAlready) {
      return;
    }
    inst.stack.child.parentSet.add(p);
    if (inst.stack.child.isActivelyListening) {
      attach(p, inst.stack.child);
    }
    if (inst.stack.offset < inst.stack.child.parents.length) {
      const maybeRemovedParent = inst.stack.child.parents[inst.stack.offset];
      if (maybeRemovedParent !== p) {
        if (!inst.stack.maybeRemoved) {
          inst.stack.maybeRemoved = [maybeRemovedParent];
        } else {
          inst.stack.maybeRemoved.push(maybeRemovedParent);
        }
      }
    }
    inst.stack.child.parents[inst.stack.offset] = p;
    inst.stack.child.parentEpochs[inst.stack.offset] = p.lastChangedEpoch;
    inst.stack.offset++;
  }
}
function whyAmIRunning() {
  const child = inst.stack?.child;
  if (!child) {
    throw new Error("whyAmIRunning() called outside of a reactive context");
  }
  const changedParents = [];
  for (let i = 0; i < child.parents.length; i++) {
    const parent = child.parents[i];
    if (parent.lastChangedEpoch > child.parentEpochs[i]) {
      changedParents.push(parent);
    }
  }
  if (changedParents.length === 0) {
    console.log(child.name, "is running but none of the parents changed");
  } else {
    console.log(child.name, "is running because:");
    for (const changedParent of changedParents) {
      console.log(
        "	",
        changedParent.name,
        "changed =>",
        changedParent.__unsafe__getWithoutCapture(true)
      );
    }
  }
}
export {
  maybeCaptureParent,
  startCapturingParents,
  stopCapturingParents,
  unsafe__withoutCapture,
  whyAmIRunning
};
//# sourceMappingURL=capture.mjs.map
